<?php

/*
 * Helper variable
 */
$o = '';

/*
 * Some configs
 */
$to_mail   = 'info@cocktail-cruiser.net';        //info@cocktail-cruiser.net
$site_name = 'Cocktail Cruiser';
$mail_sub  = 'Message from "' . $site_name . '" site';

/*
 * With 'isset( $_POST['m_name/m_email/m_msg'] ) we are checking
 * if there are any data in those fields.
 *
 * If all required fields are filled ( usually name, email and message )
 * we'll proceed
 *
 * else, we'll throw error messages ( see below )
 */

if ( isset( $_POST['m_name'] ) )
{
	if ( isset( $_POST['m_email'] ) )
	{
		if ( isset( $_POST['m_msg'] ) )
		{
			$to      = $to_mail;
			$from    = filter_var( $_POST['m_email'], FILTER_SANITIZE_EMAIL );
			$name    = filter_var( trim( $_POST['m_name'] ), FILTER_SANITIZE_STRING );
			$msg     = filter_var( trim( $_POST['m_msg'] ), FILTER_SANITIZE_STRING );

			if ( isset( $_POST['m_phone'] ) )
				$tel = '[' . $_POST['m_phone'] . ']';
			else
				$tel = '';

			$message = 'From: ' . $name . ' [' . $from . '] ' . $tel . PHP_EOL . PHP_EOL;
			$message .= $msg;
			$subject = $mail_sub;
			$headers = "MIME-Version: 1.0rn";
			$headers .= "Content-type: text/html; charset=iso-8859-1rn";
			$headers .= "From: $from\r\n";

			$send = mail( $to, $subject, $message, $headers );

			if ( $send )
			{
				$o = 'You\'r message is sent successfully. <br>We\'ll get back to you as soon as possible';
			} else
			{
				$o = 'Oops! Something wen\'t wrong. <br>Please try again!';
			}
		} else
		{
			$o .= 'Message is required!';
		}
	} else
	{
		$o .= 'Email is required!';
	}
} else
{
	$o .= 'Name is required!';
}

echo $o;